using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Management;
using IdParserM280Works.Properties; //used to save settings


/*****************************************************************/
/* Tokenworks PDF417 and Magnetic Stripe Parsing Library        */
/*  Copyright 2009, TokenWorks Inc.                      */
/* All rights reserved.                                          */
/* Redistribution and use of this code in source and/or binary   */
/* forms, with or without modification, are permitted provided   */
/* that: (1) all copies of the source code retain the above      */
/* unmodified copyright notice and this entire unmodified        */
/* section of text, (2) You or Your organization owns a valid    */
/* Developer License to this product from TokenWorks Inc.       */
/* and, (3) when any portion of this code is bundled in any      */
/* form with an application, a valid notice must be provided     */
/* within the user documentation, start-up screen or in the      */
/* help-about section of the application that specifies          */
/* TokenWorks as the provider of the Software bundled      */
/* with the application.                                         */
/*****************************************************************/



namespace IdParserM280Works
{
    public partial class frmSettings : Form
    {
        public frmSettings()
        {
            InitializeComponent();

            InitializeControlValues();
        }
        // The main control for communicating through the RS-232 port
        public  SerialPort comport = new SerialPort();


        private void InitializeControlValues()
        {
            //automatically locates the correct comport for the M280 scanner
            foreach (COMPortInfo comPort in COMPortInfo.GetCOMPortsInfo())
            {
                cmbPortName.Items.Add(comPort.Name);
            }

            if (cmbPortName.Items.Count > 0) cmbPortName.SelectedIndex = 0;
            else
            {
                MessageBox.Show(this, "There are no Serial Scanners detected on this computer.\nPlease install a COM Port and restart this app.", "No Scanners Found", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            if (cmbPortName.Items.Count != 0)
                cmbPortName.Enabled = true;

/*
//previous code, users had to manually pick correct com port
            cmbPortName.Items.Clear();
            foreach (string s in SerialPort.GetPortNames())
                cmbPortName.Items.Add(s);

            if (cmbPortName.Items.Contains(Settings.Default.PortName)) cmbPortName.Text = Settings.Default.PortName;
            else if (cmbPortName.Items.Count > 0) cmbPortName.SelectedIndex = 0;
            else
            {
                MessageBox.Show(this, "There are no COM Ports detected on this computer.\nPlease install a COM Port and restart this app.", "No COM Ports Installed", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.Close();
            }
*/
        }


        private void SaveSettings()
        {
            Settings.Default.PortName = cmbPortName.Text;
            Settings.Default.Save();
        }


        private void btnDone_Click(object sender, EventArgs e)
        {
            SaveSettings();
            this.Close();
        }



    }
}